<?php

use Dingo\Api\Routing\Router;
use Illuminate\Http\Request;

/** @var Router $api */
$api = app(Router::class);

$api->version('v1', function (Router $api) {
    $api->group(['prefix' => 'auth'], function(Router $api) {
        $api->post('signup', 'App\\Api\\V1\\Controllers\\SignUpController@signUp');
        $api->post('login', 'App\\Api\\V1\\Controllers\\LoginController@login');

        $api->post('recovery', 'App\\Api\\V1\\Controllers\\ForgotPasswordController@sendResetEmail');
        $api->post('reset', 'App\\Api\\V1\\Controllers\\ResetPasswordController@resetPassword');

        $api->post('logout', 'App\\Api\\V1\\Controllers\\LogoutController@logout');
        $api->post('refresh', 'App\\Api\\V1\\Controllers\\RefreshController@refresh');
        $api->get('me', 'App\\Api\\V1\\Controllers\\UserController@me');
    });

    $api->group(['middleware' => 'jwt.auth'], function(Router $api) {
        $api->get('protected', function() {
            return response()->json([
                'message' => 'Access to protected resources granted! You are seeing this text as you provided the token correctly.'
            ]);
        });

        $api->get('my-token', function(Request $request) {
            return response()->json([
                'token' => $request->header('Authorization')
            ]);
        });

        $api->get('refresh', [
            'middleware' => 'jwt.refresh',
            function() {
                return response()->json([
                    'message' => 'By accessing this endpoint, you can refresh your access token at each request. Check out this response headers!'
                ]);
            }
        ]);
     
    
       
    });
    
     $api->get('change-password', 'App\\Api\\V1\\Controllers\\ChangePasswordController@Index');
     $api->post('post-resetpassword', 'App\\Api\\V1\\Controllers\\ResetPasswordController@postResetPassword'); 
     $api->get('email', 'App\\Api\\V1\\Controllers\\ForgotPasswordEmailController@index');
     $api->get('email-registrasi', 'App\\Api\\V1\\Controllers\\ForgotPasswordEmailController@SendEmailRegister')->name('email-registrasi');
     $api->get('email-forgot', 'App\\Api\\V1\\Controllers\\ForgotPasswordEmailController@SendEmailForgot')->name('email-forgot');;
     $api->get('emailTest', 'App\\Api\\V1\\Controllers\\ForgotPasswordEmailController@SendEmailTest');
    $api->get('sms', 'App\\Api\\V1\\Controllers\\ForgotPasswordSMSController@index');
 
    $api->post('post-userregistrasi', 'App\\Api\\V1\\Controllers\\TerminalIndoController@postUserRegistrasi'); 
    $api->post('post-saveuserregistrasi', 'App\\Api\\V1\\Controllers\\TerminalIndoController@postSaveUserRegistrasi'); 
    $api->post('post-checkuserregistrasi', 'App\\Api\\V1\\Controllers\\TerminalIndoController@postCheckUserRegistrasi'); 
    $api->post('post-insertgetppkb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@postInsertgetPPKB'); 
    $api->post('post-insertentrypkk', 'App\\Api\\V1\\Controllers\\TerminalIndoController@postInsertentryPKK'); 
    $api->post('post-insertentrypkk_test', 'App\\Api\\V1\\Controllers\\TerminalIndoController@postInsertentryPKK_test'); 
    
    $api->post('post-deletedatappkb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@postDeleteDataPPKB'); 
    $api->post('post-deletedetilrkbmppkb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@postDeleteDetilRKBMPPKB'); 
    $api->post('post-savedatapelayanan', 'App\\Api\\V1\\Controllers\\TerminalIndoController@postSaveDataPelayananForUpload'); 
    
    $api->get('get-datauserpandu', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getDataUserPanduAPI'); 

    $api->get('get-openkegiatanpandutunda', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getOpenKegiatanPanduTundaAPI'); 

    $api->get('get-laporanpnbp', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getLaporanPNBP'); 
    $api->get('get-laporankegiatanpandutunda', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getLaporanKegiatanPanduTunda'); 
    $api->get('get-laporankegiatanpandutundaWeb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getLaporanKegiatanPanduTundaWeb'); 
    $api->get('get-laporankegiatanpandutundaInaportnetWeb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getLaporanKegiatanPanduTundaInaportnetWeb'); 
    $api->get('get-headerbuktipelayananterminalindo', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getHeaderBuktiPelayananTerminalindo'); 
    $api->get('get-pkkinaportnet', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getPKKInaportnet'); 
    $api->get('get-pkkweb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getPKKWeb'); 
    $api->get('get-headerpkk', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getHeaderPKK'); 
    $api->get('get-detailrkbm', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getDetailRKBM'); 
    $api->get('get-kegiatanpkk', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getKegiatanPKK');
    $api->get('get-headerppkb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getHeaderPPKB'); 
    $api->get('get-headerppkbweb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getHeaderPPKBWeb'); 
    $api->get('get-headerinputppkbweb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getHeaderInputPPKBWeb'); 

    $api->get('get-detailppkb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getDetailPPKB'); 
    $api->get('get-detailbuktipelayananterminalindopelayanan', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getDetailBuktiPelayananTerminalindoPelayanan'); 
    $api->get('get-headersalesorderterminalindo', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getHeaderSalesOrderTerminalindo'); 
    $api->get('get-combosearchsalesorderterminalindo', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getComboSearchSalesOrderTerminalindo'); 
    $api->get('get-combosearchrealisasipandu', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getComboSearchRealisasiPandu'); 
    $api->get('get-combodatagerakaninaportnet', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getOpenDataGerakanForComboForInaportnet'); 
    $api->get('get-combodataareapandu', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getOpenDataAreaPanduForCombo');  

    $api->get('get-combocabang', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getComboCabang'); 
    $api->get('get-combocabangWeb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getComboCabangWeb'); 
    $api->get('get-comboareapanduWeb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getComboAreaPanduWeb'); 
    $api->get('get-combopkktongkangWeb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getComboPKKTongkangWeb'); 
     
    $api->post('post-sendsoaprequest', 'App\\Api\\V1\\Controllers\\SoapIntegrationController@sendSoapRequest'); 
    $api->post('post-insertsoaprequest', 'App\\Api\\V1\\Controllers\\SoapIntegrationController@postInsertSoapRequest'); 
    $api->post('post-soapentrypkkrequest', 'App\\Api\\V1\\Controllers\\SoapController@postSoapentryPKKRequest'); 
    
    $api->post('post-insertgetppkbWeb', 'App\\Api\\V1\\Controllers\\TerminalIndoController@postInsertgetPPKBWeb'); 
    $api->get('get-getOpenDataFlowPKK', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getOpenDataFlowPKK'); 
    $api->get('get-getOpenDataFlowPKKColor', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getOpenDataFlowPKKColor'); 

    $api->post('SendRPKRO', 'App\\Api\\V1\\Controllers\\TerminalIndoController@SendRPKRO'); 

    $api->get('get-encrypt', 'App\\Api\\V1\\Controllers\\TerminalIndoController@getEncrypt'); 
    
    $api->get('test-url', function() {
        return 'sample';
    });

    $api->get('hello', function() {
        return response()->json([
            'message' => 'This is a simple example of item returned by your APIs. Everyone can see it.'
        ]);
    });
});
