<?php

namespace App\Api\V1\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mail;

date_default_timezone_set('Asia/Jakarta');

class ForgotPasswordSMSController extends Controller
{

    public function index(Request $request){
       $phoneNumber = $request->input('phone_number');
       //check email ke db atau sp
//       $user = User::where('email', $email)->first();
//       if ($user){
//            //jika user ditemukan
//            //kirim email
//           $this->sendEmail();
//           return response("Berhasil", 200);
//       }else{
//            //jika user tidak ditemukan
//           return response($email." tidak terdaftar", 403);
//       }

        //kirim email dengan parameter no hp & password yang sudah di ambil dari db/sp
        $this->sendSMS($phoneNumber);
        return response()->json([
            'code' => "0",
            'message' => "Password sudah dikirim ke No HP anda. Silahkan buka SMS yg telah dikirim. Terimakasih"
        ]);
    }

    public function sendSMS($phoneNo){
        
        $message = "Kode Verifikasi ESS: " . str_random(8);
        $url = "https://reguler.zenziva.net/apps/smsapi.php";
        $statusZenziva = '';
        $curlHandle = curl_init();
        curl_setopt($curlHandle, CURLOPT_URL, $url);
        curl_setopt($curlHandle, CURLOPT_POSTFIELDS, 'userkey='.config('zenziva.userkey').'&passkey='.config('zenziva.passkey').'&nohp='.$phoneNo.'&pesan='.urlencode($message));
        curl_setopt($curlHandle, CURLOPT_HEADER, 0);
        curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curlHandle, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($curlHandle, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curlHandle, CURLOPT_TIMEOUT,30);
        curl_setopt($curlHandle, CURLOPT_POST, 1);
        $results = curl_exec($curlHandle);
        curl_close($curlHandle);

        $XMLdata = new \SimpleXMLElement($results);
        $statusZenziva = $XMLdata->message[0]->text;
        // dd((string)$result->getBody());
        return [
            'ok' => true, 
            // 'url' => $url,
            'resultSMS' => $statusZenziva
        ];
    }
}