<?php

namespace App\Api\V1\Controllers;

use App\Http\Controllers\Controller;
use App\Api\V1\Requests\ForgotPasswordRequestEmail;
use Illuminate\Http\Request;
use Mail;
use \App\User;

date_default_timezone_set('Asia/Jakarta');

class ForgotPasswordEmailController extends Controller
{

    public function index(ForgotPasswordRequestEmail $request)
    {
        $email = $request->email;
        //check email ke db atau sp
        //$usersql = \DB::connection('sqlsrv2')->select("select top 1 * from tmuser where email=?", [$email]);
        $usersql = \DB::connection('sqlsrv2')->select("exec [ERV_SP_Get_User_by_Email] ?", [$email]);
     
        $user = collect($usersql);
        if ($user) {
            $pwd = str_random(8);

            $encrypt = bcrypt($pwd); // ini default         


            $response =   $this->updatePassword($email, $pwd);

            $response =   $this->sendEmail($email, $pwd);

            return $response;

            //jika user ditemukan
            //kirim email
            //           $this->sendEmail();
            //           return response("Berhasil", 200);
        } else {
            //jika user tidak ditemukan
            return response($email . " tidak terdaftar", 403);
        }

        //kirim email dengan parameter password yang sudah di ambil dari db/sp

        //    $email = "emi_sastra@yahoo.com";

        //        $pwd = str_random(8);

        //        $encrypt = bcrypt($pwd); // ini default         


        //     $response =   $this->updatePassword($userid, $pwd);

        //     $response =   $this->sendEmail($email, $pwd);

        //        return $response;
    }


    public function sendEmail($email, $pwd)
    {
        try {
            Mail::send('emails.sample-email', ["content" =>  $pwd], function ($message) use ($email) {
                $message->to($email, $email)
                    ->subject('Forgot Password')
                    ->from('noreply@worldterminalindo.com', 'World Terminalindo');
            });

            return response()->json([
                'code' =>  'ok',
                'message' => "Password sudah dikirim ke email anda. Silahkan buka email anda. Terima kasih"
            ]);
        } catch (Exception $e) {
            return response()->json([
                'code' => $e->getStatusCode(),
                'message' => $e->getMessage()
            ]);
        }
    }

    public function updatePassword($email, $pwd)
    {
        $encrypt = ERV_Encrypt($pwd);

        $data = \DB::connection('sqlsrv2')->statement('exec [ERV_SP_Update_Data_Password] ?, ?', [$email, $encrypt]);

        //dd($data);

        return response()
            ->json([
                'status' => 'ok',
                'email' => $email,
                '$pwd' => $pwd,
                'message' => 'success'
            ]);
    }

    public function sendEmailTest(ForgotPasswordRequestEmail $request)
    {
        $email = $request->email;

        try {
            Mail::send('emails.sample-email', ["content" =>  "hanya testing"], function ($message) use ($email) {
                $message->to($email, $email)
                    ->subject('Forgot Password')
                    ->from('noreply@worldterminalindo.com', 'World Terminalindo');
                });

            return response()->json([
                'code' =>  'ok',
                'message' => "Password sudah dikirim ke email anda. Silahkan buka email anda. Terima kasih"
            ]);
        } catch (Exception $e) {
            return response()->json([
                'code' => $e->getStatusCode(),
                'message' => $e->getMessage()
            ]);
        }
    }
    public function sendEmailForgot(Request $request)
    {
        $userid = $request->userid;
        $email = $request->email;
        $pwd = str_random(8);
        $Token = ERV_Encrypt($pwd); 
        $data = \DB::connection('sqlsrv2')->select('exec [ERV_SP_Update_Token_Forgot_Password] ? ,? ,?', [$userid,$email,$Token]);
      
        try {
            Mail::send('emails.forgotten-email', ["content" =>  "http://203.135.177.235:8081/#/reset?UserId=".$userid."&Token=".$pwd], function ($message) use ($email) {
                $message->to($email, $email)
                    ->subject('Forgotten Password Verification')
                    ->from('noreply@worldterminalindo.com', 'World Terminalindo');
                });

            return response()->json([
                'status' =>  'ok',
                'message' => "Link sudah dikirim ke email anda. Silahkan buka email anda. Terima kasih"
            ]);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getStatusCode(),
                'message' => $e->getMessage()
            ]);
        }
    }
    public function sendEmailRegister(Request $request)
    {
        $UserId = $request->UserId;
        $email = $request->Email;
        $Token = $request->Token;
        $data=[];
        try {
            Mail::send('emails.registrasi-email', ["content" =>  "http://203.135.177.235:8081/#/buat_password?UserId=".$UserId."&Token=".$Token], function ($message) use ($email) {
                $message->to($email, $email)
                    ->subject('Register Akun')
                    ->from('noreply@worldterminalindo.com', 'World Terminalindo');
                });

            return response()->json([
                'status' =>  'ok',
                // 'message' => "Link sudah dikirim ke email anda. Silahkan buka email anda. Terima kasih"
                'data'=>$data
            ]);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getStatusCode(),
                'message' => $e->getMessage()
            ]);
        }
    }

}
